* 08 Tables vehicles Fig A1.do
version 17
#d ;
set more off;
set linesize 120;

/*
cd "/Users/jfitzger/OneDrive - Bowdoin College/";
global CE "CE project 2021May/outdata/";
global outgraph "CE project 2021May/table_programs/liquidassets/graphs/";
global log "CE project 2021May/table_programs/liquidassets/log/";
*/
cap log close;
log using "${log}08 Tables Vehicles.log", replace;
putexcel set "${outgraph}99_tables", replace;

use "${CE}ce_cpc_comb_haall_v7.dta", clear;	//adjb uses 15 grp inc imputation;
count;

gen elderref=age_ref>65 & asecsurvey==0;
label var elderref "Elder Ref person (age>65)";

* recode vehicle repayments for principal and finance charges.  Missings are valid zeros.;
* Note: I verified by hand that vehfin is same as CE vehfincq+vehfinpq=quarterly finance charges;
* rvehfin=vehfin *4 and adjusted by cpi-rs-u;

replace rvehfin=0 if rvehfin==.;	// finance charges on vehicles;
label var rvehfin "Vehicles finance charges";
replace rvehprred=0 if rvehprred==.;   //rrepayment of principal, not including downpayments;
label var rvehprred "Vehicles principal paid";
gen rvehpaymnt=rvehfin + rvehprred;
label var rvehpaymnt "Vehicle payments";

gen rvehfinpos= rvehfin>0;
gen rvehprpos= rvehprred>0;
gen rvehpaypos= rvehpaymnt>0;
gen rvehpaymntpos=.;
replace rvehpaymntpos= rvehpaymnt if rvehpaypos==1;

gen rvehprredpos=.;
replace rvehprredpos= rvehprred if rvehprpos==1;

* topcode rvehpaymntpos by year.  Capped at median value of all postive auto payments, roughly $400 per month;
gen trvehpaymntpos=rvehpaymntpos;
forval k=2004(1)2019 {;
_pctile rvehpaymntpos [aweight=c_popwt] if asec==0 & year==`k', percentiles(33);
replace trvehpaymntpos = r(r1) if rvehpaymntpos > r(r1) & rvehpaymntpos<. & year==`k' & asec==0;
sum trvehpaymntpos rvehpaymntpos [aweight=c_popwt] if year==`k' & asec==0;
};
gen trvehpaymnt=trvehpaymntpos;
replace trvehpaymnt=0 if trvehpaymntpos==.;

* define resources;

gen ce_rexpkb=c_rexpk - trvehpaymnt if asec==0;  //  adjust for repayment;
gen ce_rinck=c_rinck if asec==0;

gen ce_prexpkb_onlyfin= (c_rexpk -rvehfin)<c_rspm_thres;
gen ce_prexpkb=ce_rexpkb<c_rspm_thres;
gen ce_prexpk=c_rexpk<c_rspm_thres;

* compute 20th pctle for tabs;
gen pct20rinc=.;
gen pct20rexp=.;
_pctile ce_rexp_noadj [aweight=c_popwt] if asec==0 & inlist(year,2017,2018,2019), percentiles(20);
replace pct20rexp= ce_rexp_noadj<r(r1) if asec==0 & inlist(year,2017,2018,2019);


****************** tabs;
keep if asecsurvey==0 & year>=2004;

table year [aweight=c_perpopwt] if ce_prexpk==1, stat(mean trvehpaymnt trvehpaymntpos)  stat(mean rvehpaypos) stat(freq);
table year [aweight=c_perpopwt] , stat(mean ce_prexpk ce_prexpkb) ;

********* 2017/2018/2019 cross section;


count if (year==2019|year==2018 | year==2017);
table  [aweight=c_perpopwt] if pct20rexp==1, stat(mean trvehpaymnt trvehpaymntpos rvehpaymnt rvehpaymntpos rvehpaypos)  stat(freq);
putexcel set "${outgraph}99 tables", modify sheet(r.AVeh);
putexcel A1="Vehicle Payments, Bottom Qunintile of Expenditure, 2017-2019";
putexcel A3=collect ;

table  [aweight=c_perpopwt] if (year==2019|year==2018 | year==2017) , stat(mean ce_prexpk ce_prexpkb_onlyfin ce_prexpkb) stat(freq);
putexcel set "${outgraph}99 tables", modify sheet(r.AVeh);
putexcel A15="Poverty Rates";
putexcel A16=collect ;



preserve;

collapse (mean)  ce_prexpk  ce_prexpkb ce_prexpkb_onlyfin  [aweight=c_perpopwt] , by(asecsurvey year) ;

twoway (line ce_prexpk year if asecsurvey==0, color(red)) ///
(line ce_prexpkb_onlyfin year if asecsurvey==0, color(red%50) lp(dash)) ///
(line ce_prexpkb year if asecsurvey==0, color(red%50) lp(shortdash_dot)), ///
yscale(range(.05 .25)) ylabel(0(.05).2) ///
legend(size(small) label(1 "Net SEPM") label(2 "Net SEPM w/o vehicle finance") ///
label(3 "Net SEPM w/o vehicle finance+principal") ) ///
ylabel(,labsize(small) angle(0)) ///
note("SEPM including in-kind aid and adjusted for SPM expenses and geographic COL" "Vehicle finance and principal payments are for all vehicles (used, new,and other)" ///
 "Downpayments are not deducted. Positive payments topcoded" " at median for full sample, about $3500-4000 per year") ///
title("Figure A1: CE Net SPM Poverty Rates" "with and without Vehicle Payments") ///
saving("${outgraph}08 SPM_vehicle_trend (Figure A1 C).gph", replace);
graph export "${outgraph}08 SPM_vehicle_trend (Figure A1 C).pdf",replace;

twoway (line ce_prexpk year if asecsurvey==0, color(gray)) ///
(line ce_prexpkb_onlyfin year if asecsurvey==0, color(gray) lp(dash)) ///
(line ce_prexpkb year if asecsurvey==0, color(gray) lp(shortdash_dot)), ///
yscale(range(.05 .25)) ylabel(0(.05).2) ///
legend(size(small) label(1 "Net SEPM") label(2 "Net SEPM w/o vehicle finance") ///
label(3 "Net SEPM w/o vehicle finance+principal") ) ///
ylabel(,labsize(small) angle(0)) ///
note("SEPM including in-kind aid and adjusted for SPM expenses and geographic COL" "Vehicle finance and principal payments are for all vehicles (used, new,and other)" ///
 "Downpayments are not deducted. Positive payments topcoded" " at median for full sample, about $3500-4000 per year") ///
title("Figure A1: CE Net SPM Poverty Rates" "with and without Vehicle Payments") ///
saving("${outgraph}08 SPM_vehicle_trend (Figure A1 BW).gph", replace);
graph export "${outgraph}08 SPM_vehicle_trend (Figure A1 BW).pdf",replace;

restore;

log close;
